/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.Instrumentation;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import ibm.nways.lspeed.model.LsBaseTPortMauSnmpInstr;
import ibm.nways.lspeed.model.LsFBFLPortMauSnmpInstr;
import ibm.nways.lspeed.model.LsFDDIPortMauSnmpInstr;
import ibm.nways.lspeed.model.LscBaseTPortMauSnmpInstr;

public class PortMauPollAction
implements StatusMapper,
TableStatusNamer {
    private static String bundleName = "ibm.nways.lspeed.LsGeneralResources";
    private boolean loggingOn;

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        String string = "GenericStatusName";
        Instrumentation instrumentation = statusModelInfo.getLocalModel().getInstr();
        if (instrumentation instanceof LsBaseTPortMauSnmpInstr) {
            string = "Mau10BaseTTable";
        } else if (instrumentation instanceof LsFBFLPortMauSnmpInstr) {
            string = "Mau10BaseFTable";
        } else if (instrumentation instanceof LscBaseTPortMauSnmpInstr) {
            string = "Mau100BaseTable";
        } else if (instrumentation instanceof LsFDDIPortMauSnmpInstr) {
            string = "MauFDDITable";
        }
        I18NString i18NString = new I18NString(bundleName, string);
        return i18NString;
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        String string = "GenericStatusName";
        Instrumentation instrumentation = statusModelInfo.getLocalModel().getInstr();
        if (instrumentation instanceof LsBaseTPortMauSnmpInstr) {
            string = "Mau10BaseT";
        } else if (instrumentation instanceof LsFBFLPortMauSnmpInstr) {
            string = "Mau10BaseF";
        } else if (instrumentation instanceof LscBaseTPortMauSnmpInstr) {
            string = "Mau100Base";
        } else if (instrumentation instanceof LsFDDIPortMauSnmpInstr) {
            string = "MauFDDI";
        }
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bundleName, string, objectArray);
        return i18NMsgFormat;
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
        if (statusModelInfo == null || !(statusModelInfo.get("PortMauInfo.PortMauAdminState") instanceof Integer) || !(statusModelInfo.get("PortMauInfo.PortMauStatus") instanceof Integer)) {
            statusAndExplain.statType = StatusType.UNKNOWN;
            statusAndExplain.explain = new I18NString(bundleName, "MissingPollData");
        } else {
            int n = (Integer)statusModelInfo.get("PortMauInfo.PortMauAdminState");
            int n2 = (Integer)statusModelInfo.get("PortMauInfo.PortMauStatus");
            Object[] objectArray = statusModelInfo.getIndexes();
            statusAndExplain = this.evaluatePortMauStatus(n, n2, objectArray);
        }
        statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
    }

    private StatusAndExplain evaluatePortMauStatus(int n, int n2, Object[] objectArray) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        if (n == 2) {
            statusAndExplain.statType = StatusType.ADMIN_DISABLED;
            statusAndExplain.explain = new I18NMsgFormat(bundleName, "MauStatusAdminDisabled", objectArray);
        } else {
            switch (n2) {
                case 1: {
                    statusAndExplain.statType = StatusType.NORMAL;
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "MauStatusNormal", objectArray);
                    break;
                }
                case 19: {
                    statusAndExplain.statType = StatusType.NORMAL;
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "MauStatusNormalStandby", objectArray);
                    break;
                }
                case 24: {
                    statusAndExplain.statType = StatusType.NORMAL;
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "MauStatusBackupLink", objectArray);
                    break;
                }
                case 3: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "MauStatusJabber", objectArray);
                    break;
                }
                case 23: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "MauStatusConnecting", objectArray);
                    break;
                }
                case 7: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "MauStatusLowLight", objectArray);
                    break;
                }
                case 2: {
                    statusAndExplain.statType = StatusType.CRITICAL;
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "MauStatusLinkFail", objectArray);
                    break;
                }
                case 4: {
                    statusAndExplain.statType = StatusType.CRITICAL;
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "MauStatusRemoteLinkFail", objectArray);
                    break;
                }
                case 11: {
                    statusAndExplain.statType = StatusType.CRITICAL;
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "MauStatusPartition", objectArray);
                    break;
                }
                case 10: {
                    statusAndExplain.statType = StatusType.CRITICAL;
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "MauStatusFatal", objectArray);
                    break;
                }
                case 22: {
                    statusAndExplain.statType = StatusType.ADMIN_DISABLED;
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "MauStatusOff", objectArray);
                    break;
                }
                default: {
                    statusAndExplain.statType = StatusType.UNKNOWN;
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "MauStatusUnknown", objectArray);
                    break;
                }
            }
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NString explain;

        StatusAndExplain() {
            PortMauPollAction.this = PortMauPollAction.this;
        }
    }
}

